// Initialise the global array that allows the lookup of the depth of a given object
// GM2.0 does not have a depth on objects so on import from 1.x a global array is created
// NOTE: MacroExpansion is used to insert the array initialisation at import time
gml_pragma( "global", "__global_object_depths()");

// insert the generated arrays here
global.__objectDepths[0] = 0; // PlayerObject
global.__objectDepths[1] = 0; // Player2Object
global.__objectDepths[2] = 0; // object1
global.__objectDepths[3] = 0; // object2
global.__objectDepths[4] = 0; // object3
global.__objectDepths[5] = 0; // bulletobject
global.__objectDepths[6] = 0; // bullet2object
global.__objectDepths[7] = 0; // dividerobject
global.__objectDepths[8] = 0; // object8


global.__objectNames[0] = "PlayerObject";
global.__objectNames[1] = "Player2Object";
global.__objectNames[2] = "object1";
global.__objectNames[3] = "object2";
global.__objectNames[4] = "object3";
global.__objectNames[5] = "bulletobject";
global.__objectNames[6] = "bullet2object";
global.__objectNames[7] = "dividerobject";
global.__objectNames[8] = "object8";


// create another array that has the correct entries
var len = array_length_1d(global.__objectDepths);
global.__objectID2Depth = [];
for( var i=0; i<len; ++i ) {
	var objID = asset_get_index( global.__objectNames[i] );
	if (objID >= 0) {
		global.__objectID2Depth[ objID ] = global.__objectDepths[i];
	} // end if
} // end for